local t = LoadFallbackB();

-- hits, miss, chain (max combo) for each player

-- [layering]
-- blue ring LoadActor( THEME:GetPathG("","_common/bluespin") );
-- +character images (CharacterIcon)

-- labels y from top left = 410 (SCREEN_WIDTH*0.85)
--[[
labels x from top left:
p1 - 75 (SCX-245) (SCX-138 corrected)
p2 - 426 (SCX+106) (SCX+37 corrected)
]]
-- labels are 352x20;

local temp = {
	PlayerNumber_P1 = { Normal = SCREEN_CENTER_X-192 },
	PlayerNumber_P2 = { Normal = SCREEN_CENTER_X+192, },
};

-- this frame is to be positioned after the fact.
function MakePlayerSide(pn)
	local judgeNumberY = SCREEN_HEIGHT*0.825

	-- aj nerdy stepmania shite/drunk comment:
	-- i used GetCurStageStats() in place of GetPlayedStageStats(1)
	-- in my themes but this is how danford does it and is probably
	-- better for that reason since he is a part of the people who
	-- know the most about the theming engine :[
	local playerStats = STATSMAN:GetPlayedStageStats(1):GetPlayerStageStats(pn);

	local ret = Def.ActorFrame{
		OffCommand=cmd(playcommandonchildren,"ChildOff");
		ChildOffCommand=cmd(linear,0.2;diffusealpha,0);

		Def.ActorFrame{
			Name="GradeFrame";
			InitCommand=function(self)
				self:x( pn == PLAYER_1 and SCREEN_WIDTH*0.3 or SCREEN_WIDTH*0.7 )
				self:y( SCREEN_CENTER_Y );
			end;

			LoadActor( "CharacterIcon", pn )..{
				InitCommand=function(self)
					-- characters are offset from the rings.
					local addxVals = {
						PlayerNumber_P1 = -(SCREEN_WIDTH*0.09375),
						PlayerNumber_P2 = (SCREEN_WIDTH*0.09375),
					};
					self:addx( addxVals[pn] );
				end;
				OffCommand=cmd(linear,0.2;diffusealpha,0;);
			};
		};

		LoadActor("hitmisschain")..{
			-- position based on player
			InitCommand=function(self)
				self:x( temp[pn].Normal );
				self:y(SCREEN_HEIGHT*0.875);
			end;
			OffCommand=cmd(linear,0.2;diffusealpha,0;);
		};

		-- and now make the judgments
		-- { hit = W1 or W1-W5; miss = miss; max combo }
		Def.ActorFrame{
			Name="JudgeNumbers";
			-- set the base X here.
			InitCommand=cmd(x,temp[pn].Normal);
			OffCommand=cmd(linear,0.2;diffusealpha,0;);

			LoadFont("Common normal")..{
				Name="HitNumber"..pn;
				Text=playerStats:GetTapNoteScores('TapNoteScore_W1');
				InitCommand=cmd(x,-100;y,judgeNumberY;shadowlength,0);
			};
			LoadFont("Common normal")..{
				Name="MissNumber"..pn;
				Text=playerStats:GetTapNoteScores('TapNoteScore_Miss');
				InitCommand=cmd(y,judgeNumberY;shadowlength,0);
			};
			LoadFont("Common normal")..{
				Name="ComboNumber"..pn;
				Text=playerStats:MaxCombo();
				InitCommand=cmd(x,100;y,judgeNumberY;shadowlength,0);
				BeginCommand=function(self)
					if playerStats:FullCombo() then
						-- glowy effect
						self:glowshift();
					else
						-- no effect
						self:stopeffect();
					end;
				end;
			};
		};
	};
	return ret;
end;

for pn in ivalues(GAMESTATE:GetHumanPlayers()) do
	t[#t+1] = MakePlayerSide(pn);
end;

-- cool, here's the banner.
local AssembledBanner = Def.ActorFrame{
	InitCommand=cmd(x,SCREEN_CENTER_X;y,SCREEN_CENTER_Y);
	-- banner off command
	OffCommand=cmd(playcommandonchildren,"ChildOff");
	ChildOffCommand=cmd(linear,0.2;diffusealpha,0);

	-- banner
	--[[
	Def.Banner{
		-- unlike the text below, the banner only works on song mode
		BeginCommand=function(self)
			local course = GAMESTATE:GetCurrentCourse();
			if course then
				self:LoadFromCourse(course);
			else
				self:Load( THEME:GetPathG("common fallback","banner") );
			end;
			self:zoomto(204,204);
		end;
	};
	--]]
	Def.ActorProxy{
		BeginCommand=function(self)
			local banner = SCREENMAN:GetTopScreen():GetChild('LargeBanner');
			if banner then
				self:zoomto(204,204);
				self:SetTarget(banner);
			end;
		end;
	};
	-- frame
	LoadActor( THEME:GetPathG("MusicWheelItem Song","NormalPart/songframe") )..{
		Name="SongFrame";
	};
	-- text
	LoadFont("_venacti Bold 15px")..{
		InitCommand=cmd(maxwidth,204);
		BeginCommand=function(self)
			local SongOrCourse;
			local displayText;
			-- course mode is done a bit differently but this is a stub for
			-- the old behaviour -aj
			if GAMESTATE:IsCourseMode() then
				SongOrCourse = GAMESTATE:GetCurrentCourse();
				displayText = SongOrCourse:GetDisplayFullTitle();
			else
				SongOrCourse = GAMESTATE:GetCurrentSong();
				displayText = SongOrCourse:GetDisplayFullTitle() .."\n".. SongOrCourse:GetDisplayArtist();
			end;
			self:settext(displayText);
		end;
	};
};

t[#t+1] = AssembledBanner;

return t;